/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_model_features.models.parts;

import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_630;
import org.jetbrains.annotations.NotNull;
import traben.entity_model_features.EMF;
import traben.entity_model_features.EMFManager;
import traben.entity_model_features.config.EMFConfig;
import traben.entity_model_features.models.EMFModel_ID;
import traben.entity_model_features.models.animation.EMFAnimation;
import traben.entity_model_features.models.animation.EMFAnimationEntityContext;
import traben.entity_model_features.models.animation.state.EMFEntityRenderState;
import traben.entity_model_features.models.jem_objects.EMFJemData;
import traben.entity_model_features.models.jem_objects.EMFPartData;
import traben.entity_model_features.models.parts.EMFModelPartCustom;
import traben.entity_model_features.models.parts.EMFModelPartVanilla;
import traben.entity_model_features.models.parts.EMFModelPartWithState;
import traben.entity_model_features.utils.EMFDirectoryHandler;
import traben.entity_model_features.utils.EMFUtils;
import traben.entity_texture_features.ETFApi;
import traben.entity_texture_features.features.property_reading.PropertiesRandomProvider;
import traben.entity_texture_features.features.state.ETFEntityRenderState;
import traben.entity_texture_features.utils.EntityIntLRU;

public class EMFModelPartRoot
extends EMFModelPartVanilla {
    public final EMFModel_ID modelName;
    public final class_630 vanillaRoot;
    @NotNull
    public final EntityIntLRU entitySuffixMap = new EntityIntLRU();
    private final Map<String, EMFModelPartVanilla> allVanillaParts;
    private final Int2ObjectOpenHashMap<class_630> vanillaFormatModelPartOfEachState = new Int2ObjectOpenHashMap();
    public EMFDirectoryHandler directoryContext;
    public ETFApi.ETFVariantSuffixProvider variantTester = null;
    public boolean containsCustomModel = false;
    private long lastMobCountAnimatedOn = 0L;
    private boolean hasRemovedTopLevelJemTextureFromChildren = false;
    private class_2960 jemLevelOverride = null;

    public EMFModelPartRoot(EMFModel_ID mobNameForFileAndMap, EMFDirectoryHandler directoryContext, class_630 vanillaRoot, Collection<String> optifinePartNames, Map<String, EMFModelPartVanilla> mapForCreatedParts) {
        super("root", vanillaRoot, optifinePartNames, mapForCreatedParts);
        this.allVanillaParts = mapForCreatedParts;
        this.allVanillaParts.putIfAbsent(this.name, this);
        this.modelName = mobNameForFileAndMap;
        this.directoryContext = directoryContext;
        this.vanillaRoot = vanillaRoot;
        this.receiveOneTimeRunnable(this::registerModelRunnableWithEntityTypeContext);
    }

    @Override
    protected float[] debugBoxColor() {
        return new float[]{1.0f, 0.0f, 0.0f};
    }

    public Collection<EMFModelPartVanilla> getAllVanillaPartsEMF() {
        return this.allVanillaParts.values();
    }

    private void registerModelRunnableWithEntityTypeContext() {
        EMFEntityRenderState entity = EMFAnimationEntityContext.getEmfState();
        if (entity != null) {
            String type = entity.typeString();
            EMFConfig config = (EMFConfig)EMF.config().getConfig();
            if (config.debugOnRightClick) {
                ((Set)EMFManager.getInstance().rootPartsPerEntityTypeForDebug.computeIfAbsent((Object)type, k -> new ObjectLinkedOpenHashSet())).add(this);
            }
            ((Set)EMFManager.getInstance().rootPartsPerEntityTypeForVariation.computeIfAbsent((Object)type, k -> new HashSet())).add(this);
            if (this.variantTester != null && config.logModelCreationData) {
                EMFUtils.log("Registered new variating model for: " + type);
            }
            this.receiveOneTimeRunnable(null);
        }
    }

    public void doVariantCheck() {
        EMFEntityRenderState emfState = EMFAnimationEntityContext.getEmfState();
        if (this.variantTester == null || emfState == null) {
            this.setVariantStateTo(1);
            return;
        }
        UUID id = emfState.uuid();
        int finalSuffix = this.entitySuffixMap.getInt((Object)id);
        if (finalSuffix != -1) {
            this.checkIfShouldExpireEntity(id);
        } else {
            finalSuffix = Math.max(1, this.variantTester.getSuffixForETFEntity((ETFEntityRenderState)emfState));
            this.entitySuffixMap.put(id, finalSuffix);
        }
        EMFManager.getInstance().lastModelSuffixOfEntity.put(id, finalSuffix);
        this.setVariantStateTo(finalSuffix);
    }

    public void checkIfShouldExpireEntity(UUID id) {
        if (this.variantTester.entityCanUpdate(id)) {
            switch (((EMFConfig)EMF.config().getConfig()).modelUpdateFrequency) {
                case Never: {
                    break;
                }
                case Instant: {
                    this.entitySuffixMap.removeInt((Object)id);
                    break;
                }
                default: {
                    int delay = ((EMFConfig)EMF.config().getConfig()).modelUpdateFrequency.getDelay();
                    int time = (int)(EMFAnimationEntityContext.getTime() % (float)delay);
                    if (time != Math.abs(id.hashCode()) % delay) break;
                    this.entitySuffixMap.removeInt((Object)id);
                }
            }
        }
    }

    public void addVariantOfJem(EMFJemData jemData, int variant) {
        if (((EMFConfig)EMF.config().getConfig()).logModelCreationData) {
            EMFUtils.log(" > " + jemData.getMobModelIDInfo().getfileName() + ", constructing variant #" + variant);
        }
        HashMap<String, EMFModelPartCustom> newEmfParts = new HashMap<String, EMFModelPartCustom>();
        for (EMFPartData part2 : jemData.models) {
            if (part2.part == null) continue;
            String idUnique = EMFUtils.getIdUnique(newEmfParts.keySet(), part2.id);
            newEmfParts.put(idUnique, new EMFModelPartCustom(part2, variant, part2.part, idUnique));
        }
        class_2960 rootTextureOverride = jemData.getCustomTexture();
        for (Map.Entry<String, EMFModelPartVanilla> vanillaEntry : this.allVanillaParts.entrySet()) {
            EMFModelPartVanilla thisPart = vanillaEntry.getValue();
            EMFModelPartWithState.EMFModelState vanillaState = EMFModelPartWithState.EMFModelState.copy((EMFModelPartWithState.EMFModelState)thisPart.allKnownStateVariants.get(0));
            thisPart.setFromState(vanillaState);
            thisPart.textureOverride = rootTextureOverride;
            HashMap<String, EMFModelPartCustom> children = new HashMap<String, EMFModelPartCustom>(thisPart.vanillaChildren);
            for (Map.Entry newPartEntry : newEmfParts.entrySet()) {
                EMFModelPartCustom newPart = (EMFModelPartCustom)((Object)newPartEntry.getValue());
                if (!vanillaEntry.getKey().equals(newPart.partToBeAttached)) continue;
                if (((EMFConfig)EMF.config().getConfig()).logModelCreationData) {
                    EMFUtils.log(" > > > EMF custom part attached: " + (String)newPartEntry.getKey());
                }
                if (!newPart.attach) {
                    thisPart.field_3663 = List.of();
                    thisPart.field_3661.values().forEach(part -> {
                        if (part instanceof EMFModelPartVanilla) {
                            EMFModelPartVanilla vanilla = (EMFModelPartVanilla)((Object)part);
                            if (!vanilla.isOptiFinePartSpecified) {
                                vanilla.setHideInTheseStates(variant);
                            }
                        }
                    });
                }
                children.put(EMFUtils.getIdUnique(thisPart.field_3661.keySet(), (String)newPartEntry.getKey()), newPart);
            }
            thisPart.field_3661 = children;
            thisPart.allKnownStateVariants.put(variant, (Object)thisPart.getCurrentState());
        }
        this.allKnownStateVariants.putIfAbsent(variant, (Object)EMFModelPartWithState.EMFModelState.copy((EMFModelPartWithState.EMFModelState)this.allKnownStateVariants.get(0)));
    }

    public void discoverAndInitVariants(String fallbackPropertiesName) {
        boolean exists;
        boolean printing = ((EMFConfig)EMF.config().getConfig()).logModelCreationData;
        String thisDirectoryFileName = this.directoryContext.getRelativeDirectoryLocationNoValidation(this.directoryContext.rawFileName);
        class_2960 propertyID = this.directoryContext.getRelativeFilePossiblyEMFOverridden(this.directoryContext.rawFileName + ".properties");
        if (printing) {
            EMFUtils.log(" > checking properties file: " + String.valueOf(propertyID) + " for: " + thisDirectoryFileName + ".jem");
        }
        if (!(exists = class_310.method_1551().method_1478().method_14486(propertyID).isPresent()) && ((EMFConfig)EMF.config().getConfig()).allowOptifineFallbackProperties) {
            class_2960 fallbackPropertiesID = this.directoryContext.getRelativeFilePossiblyEMFOverridden(fallbackPropertiesName + ".properties");
            if (printing) {
                EMFUtils.log(" > checking fallback .properties file: " + String.valueOf(fallbackPropertiesID) + " for: " + thisDirectoryFileName + ".jem");
            }
            if (exists = class_310.method_1551().method_1478().method_14486(fallbackPropertiesID).isPresent()) {
                propertyID = fallbackPropertiesID;
            }
        }
        if (exists) {
            ETFApi.ETFVariantSuffixProvider eTFVariantSuffixProvider;
            if (printing) {
                EMFUtils.log(" > found properties file: " + String.valueOf(propertyID) + " for: " + thisDirectoryFileName + ".jem");
            }
            if ((eTFVariantSuffixProvider = (this.variantTester = ETFApi.getVariantSupplierOrNull((class_2960)propertyID, (class_2960)EMFUtils.res(thisDirectoryFileName + ".jem"), (String[])new String[]{"models"}))) instanceof PropertiesRandomProvider) {
                PropertiesRandomProvider propertiesRandomProvider = (PropertiesRandomProvider)eTFVariantSuffixProvider;
                propertiesRandomProvider.setOnMeetsRuleHook((entity, rule) -> {
                    if (rule == null) {
                        EMFManager.getInstance().lastModelRuleOfEntity.removeInt((Object)entity.uuid());
                    } else {
                        EMFManager.getInstance().lastModelRuleOfEntity.put(entity.uuid(), rule.ruleNumber);
                    }
                });
            }
            if (this.variantTester != null) {
                IntOpenHashSet allModelVariants = this.variantTester.getAllSuffixes();
                allModelVariants.remove(1);
                allModelVariants.remove(0);
                if (!allModelVariants.isEmpty()) {
                    eTFVariantSuffixProvider = allModelVariants.iterator();
                    while (eTFVariantSuffixProvider.hasNext()) {
                        EMFJemData jemDataVariant;
                        int variant = (Integer)eTFVariantSuffixProvider.next();
                        this.setVariantStateTo(1);
                        EMFDirectoryHandler variantDirectoryContext = EMFDirectoryHandler.getDirectoryManagerOrNull(((EMFConfig)EMF.config().getConfig()).logModelCreationData, this.directoryContext.namespace, this.directoryContext.rawFileName, variant + ".jem");
                        boolean canUseVariant = this.directoryContext.validForThisBase(variantDirectoryContext);
                        if (printing) {
                            EMFUtils.log(" > incorporating variant jem file: " + this.directoryContext.namespace + ":" + this.directoryContext.rawFileName + variant + ".jem");
                        }
                        EMFJemData eMFJemData = jemDataVariant = canUseVariant ? EMFManager.getJemDataWithDirectory(variantDirectoryContext, this.modelName) : null;
                        if (jemDataVariant != null) {
                            this.addVariantOfJem(jemDataVariant, variant);
                            this.setVariantStateTo(variant);
                            EMFManager.getInstance().setupAnimationsFromJemToModel(jemDataVariant, this, variant);
                            this.containsCustomModel = true;
                            continue;
                        }
                        this.allKnownStateVariants.put(variant, (Object)((EMFModelPartWithState.EMFModelState)this.allKnownStateVariants.get(1)));
                        if (!printing) continue;
                        EMFUtils.log(" > invalid jem variant file: " + this.directoryContext.namespace + ":" + this.directoryContext.rawFileName + variant + ".jem");
                    }
                } else if (printing) {
                    EMFUtils.logWarn("properties with only 1 variant found: " + String.valueOf(propertyID) + ".");
                }
            } else {
                if (printing) {
                    EMFUtils.logWarn("null properties found for: " + String.valueOf(propertyID));
                }
                this.directoryContext = null;
            }
        } else {
            if (printing) {
                EMFUtils.logWarn("no properties or variants found for found for: [" + thisDirectoryFileName + ".jem]");
            }
            this.directoryContext = null;
        }
    }

    public void setVariant1ToVanilla0() {
        this.allKnownStateVariants.put(1, (Object)((EMFModelPartWithState.EMFModelState)this.allKnownStateVariants.get(0)));
        this.allVanillaParts.forEach((k, child) -> child.allKnownStateVariants.put(1, (Object)((EMFModelPartWithState.EMFModelState)child.allKnownStateVariants.get(0))));
    }

    public void tryRenderVanillaRootNormally(class_4587 matrixStack, class_4588 vertexConsumer, int light, int overlay) {
        if (this.vanillaRoot != null) {
            matrixStack.method_22903();
            if (((EMFConfig)EMF.config().getConfig()).getVanillaHologramModeFor(EMFAnimationEntityContext.getEMFEntity()) == EMFConfig.VanillaModelRenderMode.OFFSET) {
                matrixStack.method_46416(1.0f, 0.0f, 0.0f);
            }
            this.vanillaRoot.method_22698(matrixStack, vertexConsumer, light, overlay);
            matrixStack.method_22909();
        }
    }

    public boolean hasAnimation() {
        return this.animationHolder.hasAnimation();
    }

    public void triggerManualAnimation() {
        if (this.hasAnimation()) {
            this.animationHolder.run();
        }
    }

    public class_630 getVanillaFormatRoot() {
        if (!this.vanillaFormatModelPartOfEachState.containsKey(this.currentModelVariant)) {
            this.vanillaFormatModelPartOfEachState.put(this.currentModelVariant, (Object)this.getVanillaModelPartsOfCurrentState());
        }
        return (class_630)this.vanillaFormatModelPartOfEachState.get(this.currentModelVariant);
    }

    public void receiveAnimations(int variant, Collection<EMFAnimation> animationList) {
        ArrayList<EMFAnimation> finalList = new ArrayList<EMFAnimation>(animationList);
        if (!finalList.isEmpty()) {
            Runnable run = () -> {
                if (this.lastMobCountAnimatedOn != EMFManager.getInstance().entityRenderCount) {
                    this.lastMobCountAnimatedOn = EMFManager.getInstance().entityRenderCount;
                    if (EMFAnimationEntityContext.isFirstPersonHand && ((EMFConfig)EMF.config().getConfig()).preventFirstPersonHandAnimating) {
                        return;
                    }
                    class_630[] pausedParts = EMFAnimationEntityContext.getEntityPartsAnimPaused();
                    for (EMFAnimation emfAnimation : finalList) {
                        try {
                            if (pausedParts != null) {
                                emfAnimation.calculateAndSetIfNotPaused(pausedParts);
                                continue;
                            }
                            emfAnimation.calculateAndSet();
                        }
                        catch (Exception e) {
                            EMFUtils.logError("Error in animation expression [" + emfAnimation.animKey + "] for model [" + this.modelName.getfileName() + "] with expression [" + emfAnimation.expressionString + "].");
                            EMFUtils.logError("Error was: " + e.getMessage());
                            EMFUtils.logError("Disabling all animations for model: [" + String.valueOf(this.modelName) + "]");
                            this.allVanillaParts.values().forEach(emf -> emf.receiveRootAnimationRunnable(variant, null));
                        }
                    }
                }
            };
            this.allVanillaParts.values().forEach(emf -> emf.receiveRootAnimationRunnable(variant, run));
        }
    }

    public class_2960 getTopLevelJemTexture() {
        if (this.hasRemovedTopLevelJemTextureFromChildren) {
            return this.jemLevelOverride;
        }
        this.hasRemovedTopLevelJemTextureFromChildren = true;
        this.jemLevelOverride = this.textureOverride;
        if (this.textureOverride != null) {
            this.allVanillaParts.values().forEach(emf -> {
                if (emf.textureOverride.equals((Object)this.textureOverride)) {
                    emf.textureOverride = null;
                }
            });
        }
        return this.jemLevelOverride;
    }

    public void resetVanillaPartsToDefaults() {
        this.resetState();
        this.allVanillaParts.values().forEach(EMFModelPartWithState::resetState);
    }

    @Override
    public String toString() {
        return "[EMF root part of " + this.modelName.getfileName() + "]";
    }

    @Override
    public String toStringShort() {
        return "[EMF root part of " + this.modelName.getfileName() + "]";
    }
}

